﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;

namespace NOPWORKS.Devel.Application.WaveCutter
{
    public class MarkerData
    {
        public static string PREFIX = "marker_";
        private int index_;
        private string name_;
        private Rectangle rect_;
        private bool selected_;

        #region constructor
        //
        //  constructor
        //

        public MarkerData()
        {
            this.Clear();
        }

        public MarkerData(
            int index,
            string name)
        {
            this.Clear();
            this.index_ = index;
            this.name_ = name;
        }

        public MarkerData(
            int index,
            string name,
            Rectangle rect)
        {
            this.Clear();
            this.index_ = index;
            this.name_ = name;
            this.rect_ = rect;
        }

        #endregion  //  constructor

        #region property
        //
        //  property
        //

        public int Index
        {
            get { return this.index_; }
            set { this.index_ = value; }
        }

        public string Name
        {
            get { return this.name_; }
            set { this.name_ = value; }
        }

        public Rectangle Rect
        {
            get { return this.rect_; }
            set { this.rect_ = value; }
        }

        public bool Selected
        {
            get { return this.selected_; }
            set { this.selected_ = value; }
        }

        #endregion  //  property

        #region method
        //
        //  method
        //

        public bool CheckPointIsOnMarker(
            int x,
            int y)
        {
            if ((x >= this.rect_.Left) && (x <= this.rect_.Left + this.rect_.Width))
            {
                if ((y >= this.rect_.Top) && (y <= this.rect_.Top + this.rect_.Height))
                {
                    return true;
                }
            }
            return false;
        }

        public void Clear()
        {
            this.index_ = -1;
            this.name_ = "";
            this.rect_ = new Rectangle();
            this.selected_ = false;
        }

        #endregion  //  method
    }
}
