﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NOPWORKS.Devel.Application.WaveCutter
{
    public class MarkerDataCollection : WaveOperation
    {
        private List<MarkerData> markers_;

        #region constructor
        //
        //  constructor
        //

        public MarkerDataCollection()
        {
            this.markers_ = new List<MarkerData>();
        }

        #endregion  //  constructor

        #region property
        //
        //  property
        //

        public int Count
        {
            get { return this.markers_.Count; }
        }

        public List<MarkerData> Markers
        {
            get { return this.markers_; }
            set { this.markers_ = value; }
        }

        #endregion  //  property

        #region method
        //
        //  method
        //

        public void Add(
            MarkerData markerData)
        {
            this.markers_.Add(markerData);
        }

        public void Add(
            int pos,
            string name)
        {
            this.Add(new MarkerData(pos, name));
        }

        public void Add(
            int channelDataCount,
            int width,
            int x,
            string name)
        {
            int[] index = this.GetChannelDataIndexFromX(channelDataCount, width, x);
            if (index.Length > 0)
            {
                this.Add(new MarkerData(index[CHANNELDATAINDEX_POS], name));
            }
        }

        public void Clear()
        {
            this.markers_.Clear();
        }

        public bool CheckRange(
            int indexBegin,
            int indexEnd)
        {
            if (indexBegin > indexEnd)
            {
                return false;
            }

            for (int i = 0; i < this.markers_.Count; i++)
            {
                if ((indexBegin <= this.markers_[i].Index) && (indexEnd >= this.markers_[i].Index))
                {
                    return true;
                }
            }
            return false;
        }

        public MarkerData GetMarkerByPoint(
            int x,
            int y)
        {
            foreach (MarkerData imarker in this.markers_)
            {
                if (imarker.CheckPointIsOnMarker(x, y))
                {
                    return imarker;
                }
            }
            return null;
        }

        public MarkerData GetMarkerByRange(
            int indexBegin,
            int indexEnd)
        {
            if (indexBegin > indexEnd)
            {
                return null;
            }

            foreach (MarkerData imarker in this.markers_) 
            {
                if ((indexBegin <= imarker.Index) && (indexEnd >= imarker.Index))
                {
                    return imarker;
                }
            }
            return null;
        }

        public void Insert(
            int index,
            MarkerData markerData)
        {
            this.markers_.Insert(index, markerData);
        }

        public void Insert(
            int index,
            int pos,
            string name)
        {
            this.Insert(index, new MarkerData(pos, name));
        }

        public void Remove(
            MarkerData markerData)
        {
            this.markers_.Remove(markerData);
        }

        public void RemoveAt(
            int index)
        {
            this.markers_.RemoveAt(index);
        }

        public void RemoveSelected()
        {
            for (int i = this.markers_.Count - 1; i >= 0; i--)
            {
                if (this.markers_[i].Selected)
                {
                    this.markers_.RemoveAt(i);
                }
            }
        }

        public void ToggleMarkerSelected(
            int x,
            int y)
        {
            MarkerData marker = this.GetMarkerByPoint(x, y);
            if (marker != null)
            {
                marker.Selected = !marker.Selected;
            }
        }

        #endregion  //  method
    }
}
