﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace NOPWORKS.Devel.Application.WaveCutter
{
    public class WaveCutterCommand
    {
        public enum Commands : ushort
        {
            None,
            ReadData,
            WriteData,
            ReduceNoise,
            ClipSound,
            Normalize,
            AddSilence,
            ConvertToMonophonic,
            Split
        }

        private Commands command_;
        private float volumeThreshold_;     //  (%)
        private int timeThreshold_;         //  (millisecond)
        private float noiseThreshold_;      //  (%)
        private int blankTime_;             //  (millisecond)
        private int channel_;               //  (1:front left, 2: front right, 3:front center, 4:low frequency, 5:back left, 6:back right)

        public WaveCutterCommand()
        {
            this.Clear();
        }

        #region property
        //  property

        public int BlankTime
        {
            get { return this.blankTime_; }
            set { this.blankTime_ = value; }
        }

        public int Channel
        {
            get { return this.channel_; }
            set { this.channel_ = value; }
        }

        public Commands Command
        {
            get { return this.command_; }
            set { this.command_ = value; }
        }

        public float NoiseThreshold
        {
            get { return this.noiseThreshold_; }
            set { this.noiseThreshold_ = value; }
        }

        public int TimeThreshold
        {
            get { return this.timeThreshold_; }
            set { this.timeThreshold_ = value; }
        }

        public float VolumeThreshold
        {
            get { return this.volumeThreshold_; }
            set { this.volumeThreshold_ = value; }
        }

        #endregion  //  property

        #region method
        //  method

        public void Clear()
        {
            this.command_ = Commands.None;
            this.volumeThreshold_ = 1.0F;
            this.timeThreshold_ = 20;
            this.noiseThreshold_ = 10.0F;
            this.blankTime_ = 500;
            this.channel_ = 0;
        }

        public bool Read(
            BinaryReader reader)
        {
            try
            {
                this.Clear();
                this.command_ = (Commands)reader.ReadUInt16();
                this.volumeThreshold_ = reader.ReadSingle();
                this.timeThreshold_ = reader.ReadInt32();
                this.noiseThreshold_ = reader.ReadSingle();
                this.blankTime_ = reader.ReadInt32();
                this.channel_ = reader.ReadInt32();
                return true;
            }
            catch (Exception exp)
            {
                throw new Exception(
                    "(WaveCutterCommand.Read(reader))\n"
                    + "[" + exp.Source + "]"
                    + exp.Message + "\n",
                    exp);
            }
        }

        public bool Write(
            BinaryWriter writer)
        {
            try
            {
                writer.Write((ushort)this.command_);
                writer.Write(this.volumeThreshold_);
                writer.Write(this.timeThreshold_);
                writer.Write(this.noiseThreshold_);
                writer.Write(this.blankTime_);
                writer.Write(this.channel_);
                return true;
            }
            catch (Exception exp)
            {
                throw new Exception(
                    "(WaveCutterCommand.Write(writer))\n"
                    + "[" + exp.Source + "]"
                    + exp.Message + "\n",
                    exp);
            }
        }

        #endregion  //  method
    }
}
