﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace NOPWORKS.Devel.Application.WaveCutter
{
    public class WaveCutterCommandCollection
    {
        private List<WaveCutterCommand> items_;

        #region constructor
        //
        //  constructor
        //

        public WaveCutterCommandCollection()
        {
            this.items_ = new List<WaveCutterCommand>();
            this.Clear();
        }

        #endregion  //  constructor

        #region property
        //
        //  property
        //

        public List<WaveCutterCommand> Items
        {
            get { return this.items_; }
            set { this.items_ = value; }
        }

        #endregion  //  property

        #region method
        //
        //  method
        //

        public void Add(
            WaveCutterCommand item)
        {
            this.items_.Add(item);
        }

        public void Add(
            WaveCutterCommand.Commands command,
            float volumeThreshold,
            int timeThreshold,
            float noiseThreshold,
            int blankTime,
            int channel)
        {
            WaveCutterCommand cmd = new WaveCutterCommand();
            cmd.Command = command;
            cmd.VolumeThreshold = volumeThreshold;
            cmd.TimeThreshold = timeThreshold;
            cmd.NoiseThreshold = noiseThreshold;
            cmd.BlankTime = blankTime;
            cmd.Channel = channel;
            this.items_.Add(cmd);
        }

        public void Clear()
        {
            this.items_.Clear();
        }

        public void Remove(
            WaveCutterCommand item)
        {
            try
            {
                this.items_.Remove(item);
            }
            catch (Exception exp)
            {
                throw new Exception(
                    "(WaveCutterCommandCollection.Remove(item))\n"
                    + "[" + exp.Source + "]"
                    + exp.Message + "\n",
                    exp);
            }
        }

        public void RemoveAt(
            int index)
        {
            try
            {
                this.items_.RemoveAt(index);
            }
            catch (Exception exp)
            {
                throw new Exception(
                    "(WaveCutterCommandCollection.Remove(item))\n"
                    + "[" + exp.Source + "]"
                    + exp.Message + "\n",
                    exp);
            }
        }

        public bool ReadFromFile(
            string path)
        {
            BinaryReader reader = null;
            try
            {
                this.items_.Clear();

                reader = new BinaryReader(
                    File.Open(path, FileMode.Open, FileAccess.Read));
                while (reader.BaseStream.Position < reader.BaseStream.Length)
                {
                    WaveCutterCommand cmd = new WaveCutterCommand();
                    cmd.Read(reader);
                    this.items_.Add(cmd);
                }

                return true;
            }
            catch (Exception exp)
            {
                throw new Exception(
                    "(WaveCutterCommandCollection.Read(path))\n"
                    + "[" + exp.Source + "]"
                    + exp.Message + "\n",
                    exp);
            }
            finally
            {
                if (reader != null)
                {
                    reader.Close();
                }
            }
        }

        public void RemoveRange(
            int index,
            int count)
        {
            try
            {
                this.items_.RemoveRange(index, count);
            }
            catch (Exception exp)
            {
                throw new Exception(
                    "(WaveCutterCommandCollection.Remove(item))\n"
                    + "[" + exp.Source + "]"
                    + exp.Message + "\n",
                    exp);
            }
        }

        public void RunCommandSequence(
            WaveData data)
        {
            foreach (WaveCutterCommand icmd in this.items_)
            {
                data.VolumeThreshold = icmd.VolumeThreshold;
                data.TimeThreshold = icmd.TimeThreshold;
                data.NoiseThreshold = icmd.NoiseThreshold;
                data.BlankTime = icmd.BlankTime;
                data.Channel = icmd.Channel;
                switch (icmd.Command)
                {
                    case WaveCutterCommand.Commands.AddSilence:
                        data.AddSilence();
                        break;
                    case WaveCutterCommand.Commands.ClipSound:
                        data.ClipSound();
                        break;
                    case WaveCutterCommand.Commands.Normalize:
                        data.Normailze();
                        break;
                    case WaveCutterCommand.Commands.ReduceNoise:
                        data.ReduceNoise();
                        break;
                    case WaveCutterCommand.Commands.ConvertToMonophonic:
                        data.ConvertToMonophonic();
                        break;
                    case WaveCutterCommand.Commands.Split:
                        data.SplitSound();
                        break;
                }
            }
        }

        public bool WriteToFile(
            string path)
        {
            BinaryWriter writer = null;
            try
            {
                writer = new BinaryWriter(
                    File.Open(path, FileMode.Create, FileAccess.Write));
                foreach (WaveCutterCommand icmd in this.items_)
                {
                    icmd.Write(writer);
                }

                return true;
            }
            catch (Exception exp)
            {
                throw new Exception(
                    "(WaveCutterCommandCollection.Write(writer))\n"
                    + "[" + exp.Source + "]"
                    + exp.Message + "\n",
                    exp);
            }
            finally
            {
                if (writer != null)
                {
                    writer.Close();
                }
            }
        }

        #endregion  // method
    }
}
