﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NOPWORKS.Devel.Application.WaveCutter
{
    public class WaveOperation
    {
        public const int CHANNELDATAINDEX_POS = 0;
        public const int CHANNELDATAINDEX_RATIO = 1;

        public int[] GetChannelDataIndexFromX(
            int channelDataCount,
            int width,
            int x)
        {
            //if (this.dataChunks_.Datas.Count == 0)
            //{
            //    return new int[] { };
            //}

            //int channelDataCount = this.dataChunks_.GetChannelDataCount();
            //if (channelDataCount == 0)
            //{
            //    return new int[] { };
            //}

            float datasPerPixel = (float)channelDataCount / (float)width;
            int indexFrom = (int)(x * datasPerPixel);
            if (indexFrom > channelDataCount)
            {
                indexFrom = channelDataCount;
            }
            int indexTo = indexFrom + (int)datasPerPixel;
            if (indexTo > channelDataCount)
            {
                indexTo = channelDataCount;
            }

            return new int[] { indexFrom, indexTo };
        }

        public int GetMinChannelDataIndex(
            int[][] channelDatas)
        {
            int minLen = -1;
            for (int i = 0; i < channelDatas.Length; i++)
            {
                if ((minLen == -1) || (minLen > channelDatas[i].Length))
                {
                    minLen = channelDatas[i].Length;
                }
            }
            return minLen;
        }
    }
}
