﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NOPWORKS.Devel.Application.WaveCutter
{
    public partial class frmBatch : Form
    {
        private WaveCutterCommandCollection commands_;
        private bool cancelp_;

        public frmBatch()
        {
            InitializeComponent();

            this.commands_ = new WaveCutterCommandCollection();
            this.cancelp_ = false;
        }

        #region property
        //
        //  property
        //

        public WaveCutterCommandCollection Commands
        {
            get { return this.commands_; }
            set { this.commands_ = value; }
        }

        #endregion  //  property

        #region method
        //
        //  method
        //

        private void AddInfo(
            string msg)
        {
            while (lstInfo.Items.Count > 2000)
            {
                lstInfo.Items.RemoveAt(0);
            }
            string s = "[" + DateTime.Now.ToString("G") + "] ";
            lstInfo.Items.Add(s + msg);
            lstInfo.SetSelected(lstInfo.Items.Count - 1, true);
            lstInfo.Refresh();
        }

        #endregion  //  method

        #region event
        //
        //  event
        //

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.cancelp_ = true;
        }

        private void btnFileSelect_Click(object sender, EventArgs e)
        {
            lstFileName.Items.Clear();

            OpenFileDialog dialog = new OpenFileDialog();
            dialog.DefaultExt = ".wav";
            dialog.Multiselect = true;
            if (dialog.ShowDialog() != DialogResult.OK)
            {
                return;
            }
            foreach (string ifilename in dialog.FileNames)
            {
                lstFileName.Items.Add(ifilename);
            }
        }

        private void btnFolderSelect_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog dialog = new FolderBrowserDialog();
            dialog.ShowNewFolderButton = true;
            dialog.SelectedPath = txtFolderName.Text;
            if (dialog.ShowDialog() == DialogResult.OK)
            {
                txtFolderName.Text = dialog.SelectedPath;
            }
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            try
            {
                btnStart.Enabled = false;

                this.AddInfo("Starting process...");

                WaveData data = new WaveData();
                this.cancelp_ = false;
                for (int i = 0; i < lstFileName.Items.Count; i++)
                {
                    System.Windows.Forms.Application.DoEvents();
                    if (this.cancelp_)
                    {
                        this.AddInfo("> Canceled.");
                        break;
                    }

                    lstFileName.SetSelected(i, true);
                    string fileName = lstFileName.Items[i].ToString();

                    this.AddInfo("file name: " + fileName);
                    this.AddInfo("processing...");

                    data.ReadFromFile(fileName);
                    this.commands_.RunCommandSequence(data);

                    string savePath = txtFolderName.Text.Trim();
                    if (savePath.Equals(""))
                    {
                        if (fileName.LastIndexOf(@"\") > 0)
                        {
                            savePath = fileName.Substring(
                                0, 
                                fileName.LastIndexOf(@"\"));
                        }
                    }
                    if (!savePath.Substring(savePath.Length - 1).Equals(@"\"))
                    {
                        savePath += @"\";
                    }
                    string saveFileName = txtFileName.Text;
                    if (fileName.LastIndexOf(@"\") > 0)
                    {
                        fileName = fileName.Substring(fileName.LastIndexOf(@"\") + 1);
                    }
                    saveFileName = saveFileName.Replace("%filename%", fileName);
                    saveFileName = savePath + saveFileName;

                    this.AddInfo("> write to: " + saveFileName);

                    if (File.Exists(saveFileName))
                    {
                        if (MessageBox.Show(
                            saveFileName + "\n"
                            + "file exist.\n"
                            + "over write this file?",
                            System.Windows.Forms.Application.ProductName,
                            MessageBoxButtons.YesNo,
                            MessageBoxIcon.Question) != DialogResult.Yes)
                        {
                            this.AddInfo("> file exist.");
                            this.AddInfo("> don't write the file.");
                            continue;
                        }
                    }

                    data.WriteData(saveFileName);

                    this.AddInfo("> done.");
                }

                this.AddInfo("process completed.");
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmBatch.btnStart_Click(sender, e))\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    System.Windows.Forms.Application.ProductName,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            finally
            {
                btnStart.Enabled = true;
            }
        }

        private void frmBatch_Load(object sender, EventArgs e)
        {
            this.Text =
                System.Windows.Forms.Application.ProductName
                + "[Batch]";
        }

        #endregion  //  event
    }
}
