﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NOPWORKS.Devel.Application.WaveCutter
{
    public partial class frmWaveCutter : Form
    {
        private const int COL_COMMAND = 0;
        private const int COL_VOLUMETHRESHOLD = 1;
        private const int COL_TIMETHRESHOLD = 2;
        private const int COL_NOISETHRESHOLD = 3;
        private const int COL_BLANKTIME = 4;
        private WaveData waveData_;
        private WaveCutterCommandCollection commands_;
        private System.Media.SoundPlayer player;
        private int mouseX1_;
        private int mouseY1_;
        private int mouseX2_;
        private int mouseY2_;

        public frmWaveCutter()
        {
            InitializeComponent();

            this.waveData_ = new WaveData();
            this.commands_ = new WaveCutterCommandCollection();
            this.player = new System.Media.SoundPlayer();
            player.LoadCompleted += new AsyncCompletedEventHandler(player_LoadCompleted);
            mouseX1_ = mouseY1_ = mouseX2_ = mouseY2_ = 0;
        }

        #region method
        //
        //  method
        //

        private void AddCommand(
            WaveCutterCommand.Commands command)
        {
            this.waveData_.VolumeThreshold = (float)nudVolumeThreshold.Value;
            this.waveData_.TimeThreshold = (int)nudTimeThreshold.Value;
            this.waveData_.NoiseThreshold = (float)nudNoiseThreshold.Value;
            this.waveData_.BlankTime = (int)nudBlankTime.Value;
            this.waveData_.Channel = (int)cmbMono.SelectedIndex;
            this.commands_.Add(
                command,
                this.waveData_.VolumeThreshold,
                this.waveData_.TimeThreshold,
                this.waveData_.NoiseThreshold,
                this.waveData_.BlankTime,
                this.waveData_.Channel);
            this.SetCommandList();
        }

        private void AddSilence()
        {
            this.Cursor = Cursors.WaitCursor;

            this.AddCommand(WaveCutterCommand.Commands.AddSilence);

            try
            {
                this.waveData_.AddSilence();
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.AddSilence())\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    System.Windows.Forms.Application.ProductName,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }

            picGraph.Invalidate();
            picGraph.Focus();

            this.Cursor = Cursors.Default;
        }

        private void BeSilentRegion()
        {
            int x1 =
                ((mouseX1_ < 0)
                ? 0
                : ((mouseX1_ > picGraph.ClientRectangle.Width)
                    ? picGraph.ClientRectangle.Width
                    : mouseX1_));
            int x2 =
                ((mouseX2_ < 0)
                ? 0
                : ((mouseX2_ > picGraph.ClientRectangle.Width)
                    ? picGraph.ClientRectangle.Width
                    : mouseX2_));
            if (x1 > x2)
            {
                int n = x1;
                x1 = x2;
                x2 = n;
            }

            this.Cursor = Cursors.WaitCursor;
            try
            {
                this.waveData_.BeSilentRegion(picGraph.ClientRectangle.Width, x1, x2);
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.BeSilentRegion())\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    System.Windows.Forms.Application.ProductName,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            finally
            {
                picGraph.Invalidate();
                this.Cursor = Cursors.Default;
            }
        }

        private void ClearMarker()
        {
            this.Cursor = Cursors.WaitCursor;
            this.waveData_.ClearMarker();
            picGraph.Invalidate();
            this.Cursor = Cursors.Default;
        }

        private void ClipSound()
        {
            this.Cursor = Cursors.WaitCursor;

            this.AddCommand(WaveCutterCommand.Commands.ClipSound);

            try
            {
                this.waveData_.ClipSound();
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.ClipSound())\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    System.Windows.Forms.Application.ProductName,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }

            picGraph.Invalidate();
            picGraph.Focus();

            this.Cursor = Cursors.Default;
        }

        private void ConvertToMono()
        {
            string s = cmbMono.Text.Substring(0, 1);
            if (s.Length < 1)
            {
                return;
            }

            try
            {
                this.Cursor = Cursors.WaitCursor;
                this.AddCommand(WaveCutterCommand.Commands.ConvertToMonophonic);
                this.waveData_.ConvertToMonophonic();
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.ConvertToMonophonic())\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    System.Windows.Forms.Application.ProductName,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            finally
            {
                this.ShowFileInfo(this.waveData_);
                picGraph.Invalidate();
                picGraph.Focus();
                this.Cursor = Cursors.Default;
            }
        }

        private void CutRegion()
        {
            int x1 =
                ((mouseX1_ < 0)
                ? 0
                : ((mouseX1_ > picGraph.ClientRectangle.Width)
                    ? picGraph.ClientRectangle.Width
                    : mouseX1_));
            int x2 =
                ((mouseX2_ < 0)
                ? 0
                : ((mouseX2_ > picGraph.ClientRectangle.Width)
                    ? picGraph.ClientRectangle.Width
                    : mouseX2_));
            if (x1 > x2)
            {
                int n = x1;
                x1 = x2;
                x2 = n;
            }

            this.Cursor = Cursors.WaitCursor;
            try
            {
                this.waveData_.CutRegion(picGraph.ClientRectangle.Width, x1, x2);
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.CutRegion())\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    System.Windows.Forms.Application.ProductName,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            finally
            {
                picGraph.Invalidate();
                this.Cursor = Cursors.Default;
            }
        }

        private void DrawWave(
            Graphics g,
            WaveData waveData)
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;

                Rectangle rect = this.GetSelectedRect();

                this.waveData_.VolumeThreshold = (float)nudVolumeThreshold.Value;
                this.waveData_.TimeThreshold = (int)nudTimeThreshold.Value;
                this.waveData_.BlankTime = (int)nudBlankTime.Value;
                this.waveData_.NoiseThreshold = (float)nudNoiseThreshold.Value;
                waveData.DrawWaveform(g, rect);
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.DrawWave)\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    "WaveCutter",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            finally
            {
                this.Cursor = Cursors.Default;
            }
        }

        private Rectangle GetSelectedRect()
        {
            int x1 = mouseX1_;
            int y1 = 0;
            int x2 = mouseX2_;
            int y2 = picGraph.ClientRectangle.Height;
            if (x1 > x2)
            {
                x1 = mouseX2_;
                x2 = mouseX1_;
            }
            if (y1 > y2)
            {
                y1 = mouseY2_;
                y2 = mouseY1_;
            }
            return new Rectangle(x1, y1, x2 - x1, y2 - y1);
        }

        private void MaximizeVolume()
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;
                this.AddCommand(WaveCutterCommand.Commands.Normalize);
                this.waveData_.Normailze();
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.MaximizeVolume())\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    System.Windows.Forms.Application.ProductName,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            finally
            {
                picGraph.Invalidate();
                picGraph.Focus();
                this.Cursor = Cursors.Default;
            }
        }

        private void PlaySound()
        {
            if (this.waveData_.DataChunks.ChannelDatas.Length <= 0)
            {
                return;
            }

            string tmpFile = Path.GetTempPath()
                + System.Windows.Forms.Application.ProductName
                + ".wav";
            FileInfo finfo = null;
            try
            {
                int channelDataCount = this.waveData_.DataChunks.GetChannelDataCount();
                int indexFrom = 0;
                int indexTo = this.waveData_.DataChunks.GetChannelDataCount();
                Rectangle rect = this.GetSelectedRect();
                if (rect.Width > 1)
                {
                    int[] selregion = this.waveData_.GetChannelDataIndexFromX(channelDataCount, picGraph.ClientRectangle.Width, rect.Left);
                    if (selregion.Length > 0)
                    {
                        indexFrom = selregion[0];
                    }
                    selregion = this.waveData_.GetChannelDataIndexFromX(channelDataCount, picGraph.ClientRectangle.Width, rect.Left + rect.Width);
                    if (selregion.Length > 0)
                    {
                        indexTo = selregion[1];
                    }
                }
                this.waveData_.WriteData(tmpFile, indexFrom, indexTo);
                finfo = new FileInfo(tmpFile);
                while (finfo.IsReadOnly)
                {
                    System.Windows.Forms.Application.DoEvents();
                    finfo.Refresh();
                }

                player.SoundLocation = tmpFile;
                player.Load();
                while (!player.IsLoadCompleted)
                {
                    System.Windows.Forms.Application.DoEvents();
                }
                player.PlaySync();
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.PlaySound)\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    "WaveCutter",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            finally
            {
                if (finfo != null)
                {
                    while (finfo.IsReadOnly)
                    {
                        System.Windows.Forms.Application.DoEvents();
                        finfo.Refresh();
                    }
                    File.Delete(tmpFile);
                }
            }
        }

        private void ReadData(
            WaveData waveData)
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;

                waveData.Clear();

                if (waveData.ReadFromFile(txtFileName.Text))
                {
                    this.ShowFileInfo(waveData);
                    cmbMono.Items.Clear();
                    if (waveData.FmtChunk.Channels > 1)
                    {
                        cmbMono.Items.Add("0:Mix");
                        for (int i = 1; i <= waveData.FmtChunk.Channels; i++)
                        {
                            string s = "";
                            switch (i)
                            {
                                case 1:
                                    s = "Front Left";
                                    break;
                                case 2:
                                    s = "Front Right";
                                    break;
                                case 3:
                                    s = "Front Center";
                                    break;
                                case 4:
                                    s = "Back Left";
                                    break;
                                case 5:
                                    s = "Back Right";
                                    break;
                            }
                            cmbMono.Items.Add(i.ToString() + ":" + s);
                        }
                        cmbMono.SelectedIndex = 0;
                    }
                }
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.ReadData)\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    System.Windows.Forms.Application.ProductName,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            finally
            {
                this.Cursor = Cursors.Default;
            }
        }

        private void ReduceNoise()
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;
                this.AddCommand(WaveCutterCommand.Commands.ReduceNoise);
                this.waveData_.ReduceNoise();
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.ReduceNoise())\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    System.Windows.Forms.Application.ProductName,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            finally
            {
                picGraph.Invalidate();
                picGraph.Focus();
                this.Cursor = Cursors.Default;
            }
        }

        private void RemoveSelectedMarker()
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;
                this.waveData_.RemoveSelectedMarker();
                picGraph.Invalidate();
                picGraph.Focus();
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.RemoveSelectedMarker)\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    "WaveCutter",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            finally
            {
                this.Cursor = Cursors.Default;
            }
        }

        private void RunCommandSequence()
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;
                this.commands_.RunCommandSequence(this.waveData_);
                picGraph.Invalidate();
                picGraph.Focus();
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.RunCommandSequence)\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    "WaveCutter",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            finally
            {
                this.Cursor = Cursors.Default;
            }
        }

        private void SetCommandList()
        {
            grdCommand.RowCount = 0;
            foreach (WaveCutterCommand icmd in this.commands_.Items)
            {
                grdCommand.Rows.Add();
                int rowIndex = grdCommand.Rows.Count - 1;
                grdCommand[COL_COMMAND, rowIndex].Value = icmd.Command.ToString();
                grdCommand[COL_VOLUMETHRESHOLD, rowIndex].Value = icmd.VolumeThreshold.ToString();
                grdCommand[COL_TIMETHRESHOLD, rowIndex].Value = icmd.TimeThreshold.ToString();
                grdCommand[COL_NOISETHRESHOLD, rowIndex].Value = icmd.NoiseThreshold.ToString();
                grdCommand[COL_BLANKTIME, rowIndex].Value = icmd.BlankTime.ToString();
            }
            if (grdCommand.Rows.Count > 0)
            {
                grdCommand.CurrentCell = grdCommand[0, grdCommand.Rows.Count - 1];
            }
        }

        private void ShowFileInfo(
            WaveData waveData)
        {
            lstInfo.Items.Clear();
            lstInfo.Items.Add("file format ID: " + waveData.FileFormatIDString);
            lstInfo.Items.Add("file size(byte): " + waveData.FileSize.ToString());
            lstInfo.Items.Add("calculated file size(byte): " + waveData.GetSize().ToString());
            lstInfo.Items.Add("data format ID: " + waveData.DataFormatIDString);
            lstInfo.Items.Add("fmt chunk ID: " + waveData.FmtChunk.ChunkIDString);
            lstInfo.Items.Add("fmt chunk size(byte): " + waveData.FmtChunk.ChunkSize.ToString());
            lstInfo.Items.Add("compression code: " + waveData.FmtChunk.FormatID.ToString());
            lstInfo.Items.Add("channels: " + waveData.FmtChunk.Channels.ToString());
            lstInfo.Items.Add("sample/sec: " + waveData.FmtChunk.SamplesPerSec.ToString());
            lstInfo.Items.Add("bytes/sec: " + waveData.FmtChunk.BytesPerSec.ToString());
            lstInfo.Items.Add("block alignment(byte): " + waveData.FmtChunk.BlockAlign.ToString());
            lstInfo.Items.Add("bits/sample: " + waveData.FmtChunk.BitsPerSample.ToString());
            lstInfo.Items.Add("ExSize(byte): " + waveData.FmtChunk.ExSize.ToString());
            foreach (WaveDataChunk idata in waveData.DataChunks.Datas)
            {
                lstInfo.Items.Add("chunk ID: " + idata.DataIDString);
                lstInfo.Items.Add("chunk header data size(byte): " + idata.DataSize.ToString());
                lstInfo.Items.Add("data size(byte): " + idata.DataSize.ToString());
            }
        }

        private void SplitSound()
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;
                this.AddCommand(WaveCutterCommand.Commands.Split);
                this.waveData_.SplitSound();
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.SplitSound())\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    System.Windows.Forms.Application.ProductName,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            finally
            {
                picGraph.Invalidate();
                picGraph.Focus();
                this.Cursor = Cursors.Default;
            }
        }

        private void WriteWaveData()
        {
            try
            {
                if (txtSaveFileName.Text.Trim().Length > 0)
                {
                    this.Cursor = Cursors.WaitCursor;
                    Rectangle rect = this.GetSelectedRect();
                    if (rect.Width > 0)
                    {
                        int channelDataCount = this.waveData_.DataChunks.GetChannelDataCount();
                        int indexFrom = 0;
                        int indexTo = channelDataCount;
                        int[] tmpIndex = this.waveData_.DataChunks.GetChannelDataIndexFromX(channelDataCount, picGraph.ClientRectangle.Width, rect.Left);
                        if (tmpIndex.Length > 0)
                        {
                            indexFrom = tmpIndex[0];
                        }
                        tmpIndex = this.waveData_.GetChannelDataIndexFromX(channelDataCount, picGraph.ClientRectangle.Width, rect.Left + rect.Width);
                        if (tmpIndex.Length > 0)
                        {
                            indexTo = tmpIndex[1];
                        }
                        this.waveData_.WriteData(txtSaveFileName.Text, indexFrom, indexTo);
                    }
                    else
                    {
                        this.waveData_.WriteData(txtSaveFileName.Text);
                    }
                    this.ShowFileInfo(this.waveData_);
                }
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.WriteWaveData)\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    "WaveCutter",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            finally
            {
                this.Cursor = Cursors.Default;
            }
        }

        #endregion  //  method

        #region event
        //
        //  event
        //

        private void btnAddMarker_Click(object sender, EventArgs e)
        {

        }

        private void btnAddSilence_Click(object sender, EventArgs e)
        {
            this.AddSilence();
        }

        private void btnBatch_Click(object sender, EventArgs e)
        {
            frmBatch frm = new frmBatch();
            frm.Commands = this.commands_;
            frm.ShowDialog();
            picGraph.Focus();
        }

        private void btnClearMarker_Click(object sender, EventArgs e)
        {
            this.ClearMarker();
        }

        private void btnClearNoise_Click(object sender, EventArgs e)
        {
            this.ReduceNoise();
        }

        private void btnDeleteSilence_Click(object sender, EventArgs e)
        {
            this.ClipSound();
        }

        private void btnDelMarker_Click(object sender, EventArgs e)
        {
            this.RemoveSelectedMarker();
        }

        private void btnFolderSelect_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog dialog = new FolderBrowserDialog();
            dialog.ShowNewFolderButton = false;
            dialog.SelectedPath = txtFolderName.Text;
            if (dialog.ShowDialog() == DialogResult.OK)
            {
                txtFolderName.Text = dialog.SelectedPath;
                string[] files = Directory.GetFiles(
                    txtFolderName.Text,
                    "*.wav");
                Array.Sort(files);
                lstFiles.Items.Clear();
                for (int i = 0; i < files.Length; i++)
                {
                    string tmpFileName = files[i];
                    if (tmpFileName.LastIndexOf(@"\") > 0)
                    {
                        tmpFileName = tmpFileName.Substring(tmpFileName.LastIndexOf(@"\") + 1);
                    }
                    lstFiles.Items.Add(tmpFileName);
                }
            }
        }

        private void btnMono_Click(object sender, EventArgs e)
        {
            this.ConvertToMono();

        }

        private void btnNormailze_Click(object sender, EventArgs e)
        {
            this.MaximizeVolume();
        }

        private void btnOpenFile_Click(object sender, EventArgs e)
        {
            OpenFileDialog dialog = new OpenFileDialog();
            dialog.DefaultExt = ".wav";
            dialog.Multiselect = false;
            dialog.FileName = txtFileName.Text;
            if (dialog.ShowDialog() == DialogResult.OK)
            {
                txtFileName.Text = dialog.FileName;
                this.Cursor = Cursors.WaitCursor;
                ReadData(this.waveData_);
                picGraph.Invalidate();
                this.Cursor = Cursors.Default;
            }
        }

        private void btnPlay_Click(object sender, EventArgs e)
        {
            this.PlaySound();
            picGraph.Focus();
        }

        private void btnReadData_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            ReadData(this.waveData_);
            picGraph.Invalidate();
            this.Cursor = Cursors.Default;
        }

        private void btnRedraw_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            picGraph.Invalidate();
            this.Cursor = Cursors.Default;
        }

        private void btnSaveFile_Click(object sender, EventArgs e)
        {
            SaveFileDialog dialog = new SaveFileDialog();
            dialog.DefaultExt = ".wav";
            dialog.FileName = txtSaveFileName.Text;
            if (dialog.ShowDialog() == DialogResult.OK)
            {
                txtSaveFileName.Text = dialog.FileName;
            }
        }

        private void btnSplit_Click(object sender, EventArgs e)
        {
            this.SplitSound();
        }

        private void btnTest_Click(object sender, EventArgs e)
        {
            this.RunCommandSequence();
            this.picGraph.Focus();
        }

        private void btnWriteData_Click(object sender, EventArgs e)
        {
            this.WriteWaveData();
        }

        private void frmWaveCutter_Load(object sender, EventArgs e)
        {
            this.Text = System.Windows.Forms.Application.ProductName
                + "_" + System.Windows.Forms.Application.ProductVersion;
        }

        private void frmWaveCutter_KeyDown(object sender, KeyEventArgs e)
        {
            try
            {
                e.SuppressKeyPress = true;

                switch (e.KeyCode)
                {
                    case Keys.Delete:
                        if (this.ActiveControl.Equals(this.grdCommand))
                        {
                            e.SuppressKeyPress = false;
                        }
                        else if (!e.Shift && !e.Control && !e.Alt)
                        {
                            this.CutRegion();
                        }
                        else if (e.Shift && !e.Control & !e.Alt)
                        {
                            this.BeSilentRegion();
                        }
                        break;
                    case Keys.Space:
                        if (this.ActiveControl.GetType().Equals(typeof(Button)))
                        {
                            e.SuppressKeyPress = false;
                        }
                        else if (e.Shift || e.Control || e.Alt)
                        {
                            break;
                        }
                        this.PlaySound();
                        break;
                    case Keys.R:
                        if (!e.Shift && e.Control & !e.Alt)
                        {
                            this.RunCommandSequence();
                        }
                        else
                        {
                            goto default;
                        }
                        break;
                    case Keys.S:
                        if (!e.Shift && e.Control & !e.Alt)
                        {
                            this.WriteWaveData();
                        }
                        else
                        {
                            goto default;
                        }
                        break;
                    default:
                        e.SuppressKeyPress = false;
                        break;
                }
            }
            catch (Exception exp)
            {
                MessageBox.Show(
                    "(frmWaveCutter.frmWaveCutter_KeyDown)\n"
                    + "[" + exp.Source + "]"
                    + exp.Message,
                    "WaveCutter",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
        }

        private void frmWaveCutter_Paint(object sender, PaintEventArgs e)
        {
        }

        private void grdCommand_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {

        }

        private void grdCommand_KeyDown(object sender, KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                case Keys.Delete:
                    if (grdCommand.CurrentCellAddress.Y >= 0)
                    {
                        this.commands_.RemoveAt(grdCommand.CurrentCellAddress.Y);
                        this.SetCommandList();
                    }
                    break;
            }
        }

        private void lstFiles_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (lstFiles.Items.Count <= 0)
            {
                return;
            }
            else if (lstFiles.SelectedIndex < 0)
            {
                return;
            }

            string fileName = txtFolderName.Text + "\\" + lstFiles.SelectedItem.ToString();
            txtFileName.Text = fileName;
            txtSaveFileName.Text = fileName;
            this.btnReadData_Click(null, null);
        }

        private void nudBlankTime_ValueChanged(object sender, EventArgs e)
        {

        }

        private void nudNoiseThreshold_ValueChanged(object sender, EventArgs e)
        {
        }

        private void nudTimeThreshold_ValueChanged(object sender, EventArgs e)
        {
        }

        private void nudVolumeThreshold_ValueChanged(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            picGraph.Invalidate();
            this.Cursor = Cursors.Default;
        }

        private void picGraph_Click(object sender, EventArgs e)
        {

        }

        private void picGraph_MouseDown(object sender, MouseEventArgs e)
        {
            switch (e.Button)
            {
                case MouseButtons.Left:
                    mouseX1_ = e.X;
                    mouseY1_ = e.Y;
                    mouseX2_ = mouseX1_;
                    mouseY2_ = mouseY1_;
                    this.waveData_.ToggleMarkerSelected(this.mouseX1_, this.mouseY1_);
                    picGraph.Invalidate();
                    picGraph.Focus();
                    break;
            }
        }

        private void picGraph_MouseMove(object sender, MouseEventArgs e)
        {
            switch (e.Button)
            {
                case MouseButtons.Left:
                    mouseX2_ = e.X;
                    mouseY2_ = e.Y;
                    if (!this.waveData_.FileFormatIDString.Equals(""))
                    {

                    }
                    picGraph.Invalidate();
                    break;
            }
        }

        private void picGraph_MouseUp(object sender, MouseEventArgs e)
        {
        }

        private void picGraph_Paint(object sender, PaintEventArgs e)
        {
            this.DrawWave(e.Graphics, this.waveData_);

            e.Graphics.DrawString(
                "(" + mouseX1_.ToString() + ", " + mouseY1_.ToString() + ") "
                + "(" + mouseX2_.ToString() + ", " + mouseY2_.ToString() + ") ",
                new Font("Arial", 10),
                new SolidBrush(Color.FromArgb(128, 0x00, 0x00, 0xff)),
                0,
                0);
        }

        // Handler for the LoadCompleted event.
        private void player_LoadCompleted(
            object sender,
            AsyncCompletedEventArgs e)
        {
            string message = String.Format("LoadCompleted");
            Console.WriteLine("{0}", message);
        }

        #endregion  //  event
    }
}
